/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.messaging;

import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.MessageConsumer;
import de.willuhn.jameica.messaging.MessagingQueue;
import de.willuhn.jameica.messaging.NamedConcurrentQueue;
import de.willuhn.logging.Logger;
import java.util.HashMap;
import java.util.Iterator;

public final class MessagingFactory
implements MessagingQueue {
    private static MessagingFactory singleton = null;
    private MessagingQueue defaultQueue = new NamedConcurrentQueue("[default]");
    private HashMap<String, MessagingQueue> queues = new HashMap();

    private MessagingFactory() {
    }

    public static synchronized MessagingFactory getInstance() {
        if (singleton == null) {
            singleton = new MessagingFactory();
        }
        return singleton;
    }

    @Override
    public int getQueueSize() {
        return this.defaultQueue.getQueueSize();
    }

    public MessagingQueue getMessagingQueue(String name) {
        MessagingQueue queue = this.queues.get(name);
        if (queue == null) {
            queue = new NamedConcurrentQueue(name);
            this.queues.put(name, queue);
        }
        return queue;
    }

    @Override
    public void registerMessageConsumer(MessageConsumer consumer) {
        this.defaultQueue.registerMessageConsumer(consumer);
    }

    @Override
    public void unRegisterMessageConsumer(MessageConsumer consumer) {
        this.defaultQueue.unRegisterMessageConsumer(consumer);
    }

    @Override
    public synchronized void close() {
        Logger.info((String)"shutting down messaging factory");
        try {
            Iterator<String> it = this.queues.keySet().iterator();
            while (it.hasNext()) {
                MessagingQueue q = this.queues.get(it.next());
                q.close();
            }
        }
        finally {
            this.defaultQueue.close();
            this.queues.clear();
        }
    }

    @Override
    public void sendMessage(Message message) {
        this.defaultQueue.sendMessage(message);
    }

    @Override
    public void sendSyncMessage(Message message) {
        this.defaultQueue.sendSyncMessage(message);
    }

    @Override
    public void queueMessage(Message message) {
        this.defaultQueue.queueMessage(message);
    }

    @Override
    public void flush() {
        try {
            Iterator<String> it = this.queues.keySet().iterator();
            while (it.hasNext()) {
                MessagingQueue q = this.queues.get(it.next());
                q.flush();
            }
        }
        finally {
            this.defaultQueue.flush();
        }
    }
}

